//-----------------------------------------------------------------------------
// Microsoft OLE DB RowsetViewer
// Copyright (C) 1994 - 1998 By Microsoft Corporation.
//
// @doc
//
// @module CTABLE.H
//
//-----------------------------------------------------------------------------------

#ifndef _CTABLE_H_
#define _CTABLE_H_


//////////////////////////////////////////////////////////////////////////////
// Defines
//
//////////////////////////////////////////////////////////////////////////////
enum ROWSETSOURCE
{
	ROWSET_FROMSCHEMA,
	ROWSET_FROMCOMMAND,
	ROWSET_FROMCOMMANDWITHPARAMETERS,
	ROWSET_FROMOPENROWSET,
	ROWSET_FROMENUM,
	ROWSET_FROMROWSETCOLUMNSROWSET,
	ROWSET_FROMCOMMANDCOLUMNSROWSET,
 	ROWSET_FROMCOMMANDDATASET,
 	ROWSET_FROMAXISDATASET,
};

enum BINDCOLS
{
	BIND_ALLCOLS				= 1,
	BIND_ALLCOLSEXPECTBOOKMARK	= 2,
	BIND_UPDATEABLECOLS			= 4,
	BIND_BOOKMARKONLY			= 8,
};


//////////////////////////////////////////////////////////////////////////////
// Includes
//
//////////////////////////////////////////////////////////////////////////////
#include "DataSource.h"
#include "Main.h"


//////////////////////////////////////////////////////////////////////////////
// Forwards
//
//////////////////////////////////////////////////////////////////////////////
class CRowsetNotify;
class CAsynchNotify;
class CRowPosChange;
class CRowPos;
class CDataset;
class CMultipleResults;


/////////////////////////////////////////////////////////////////
// CRowset 
//
/////////////////////////////////////////////////////////////////
class CRowset : public CBase
{
public:
	//Constructors
	CRowset(CMDIChild* pCMDIChild, CDataSource* pCDataSource);
	virtual ~CRowset();
	
	//IUnknown Helpers
	virtual HRESULT SetInterface(REFIID riid, IUnknown* pIUnknown);

	//Members
	virtual HRESULT CreateConnection(IUnknown* pIUnknown, ULONG cPropSets, DBPROPSET* rgPropSets, DWORD dwConnectOptions);
	virtual HRESULT CreateConnection(CRowset* pCRowset, BOOL bNewSession = TRUE);
	
	virtual HRESULT GetColInfo(IColumnsInfo* pIColumnsInfo = NULL);
	virtual DBCOLUMNINFO*	GetColInfo(ULONG iOrdinal);
	virtual DBBINDING*		GetBinding(ULONG iOrdinal);
	virtual WCHAR*			GetColName(ULONG iOrdinal);

	virtual HRESULT	ValidateRow(HROW hRow, ULONG ulRefCount = 1);
	virtual HRESULT	ValidateAccessor(HACCESSOR hAccessor, ULONG ulRefCount = 1);

	virtual HRESULT GetData(HROW hRow, HACCESSOR hAccessor = NULL, void* pData = NULL);
	virtual HRESULT GetOriginalData(HROW hRow, HACCESSOR hAccessor = NULL, void* pData = NULL);
	virtual HRESULT GetVisibleData(HROW hRow, HACCESSOR hAccessor = NULL, void* pData = NULL);
	virtual HRESULT GetBookmark(HROW hRow, ULONG* pcbBookmark, BYTE** ppBookmark, void** ppData);

	virtual HRESULT GetNextRows(LONG lOffset, LONG cRows, ULONG* pcRowsObtained, HROW** prghRows);
	virtual HRESULT AddRefRows(ULONG cRows, HROW* rghRows, ULONG* rgRefCounts = NULL);
	virtual HRESULT ReleaseRows(ULONG cRows, HROW* rghRows, ULONG* rgRefCounts = NULL);
	
	virtual HRESULT SetColumnData(DBBINDING* pBinding, void* pData, DBSTATUS dwStatus, CHAR* pszValue);
	virtual HRESULT GetColumnData(DBBINDING* pBinding, void* pData, DBSTATUS* pdwStatus, ULONG* pdwLength, DBTYPE* pwSubType, CHAR* pszValue, ULONG ulMaxSize, DWORD dwFlags, DBTYPE wBaseType = DBTYPE_STR);

	virtual HRESULT CreateAccessors(BOOL fBindBookmark);
	virtual HRESULT CreateAccessor(DBACCESSORFLAGS dwAccessorFlags, ULONG cBindings, DBBINDING* rgBindings, ULONG cRowSize, HACCESSOR* phAccessor);
	virtual HRESULT SetupBindings(BINDCOLS eBindCols, ULONG* cBindings, DBBINDING** prgBindings, ULONG* pcRowSize = NULL, BOOL* pbOutofLine = NULL);
	virtual HRESULT ReleaseAccessor(HACCESSOR* phAccessor);

	virtual HRESULT ReleaseRowset();
	virtual HRESULT CreateRowset(ROWSETSOURCE eRowsetSource, ULONG cPropSets, DBPROPSET* rgPropSets, LONG* pcRowsAffected, DBID* pTableID, DBID* pIndexID, REFIID riid = IID_IUnknown, const GUID* pGuidSchema = NULL, ULONG cRestrictions = 0, VARIANT* rgRestrictions = NULL);
	virtual HRESULT CreateRowset(IUnknown* pIRowset);
 	virtual HRESULT CreateDataset(ROWSETSOURCE eRowsetSource, LONG* pcRowsAffected, WCHAR* pwszCmd);
 	
	virtual HRESULT AdviseListeners();
	virtual HRESULT UnadviseListeners();

	//Rowset
	//[MANADATORY]
	IAccessor*					m_pIAccessor;
	IColumnsInfo*				m_pIColumnsInfo;
	IConvertType*				m_pIConvertType;
	IRowset*					m_pIRowset;
	IRowsetInfo*				m_pIRowsetInfo;
	//[OPTIONAL]
	IColumnsRowset*				m_pIColumnsRowset;
	IConnectionPointContainer*	m_pIConnectionPointContainer;
	IDBAsynchStatus*			m_pIDBAsynchStatus;
	IRowsetChange*				m_pIRowsetChange;
	IRowsetIdentity*			m_pIRowsetIdentity;
	IRowsetLocate*				m_pIRowsetLocate;
	IRowsetFind*				m_pIRowsetFind;
	IRowsetView*				m_pIRowsetView;
	IChapteredRowset*			m_pIChapteredRowset;
	IRowsetResynch*				m_pIRowsetResynch;
	IRowsetScroll*				m_pIRowsetScroll;
	IRowsetUpdate*				m_pIRowsetUpdate;
	ISupportErrorInfo*			m_pISupportErrorInfo;

	//Extra interfaces
	IConnectionPoint*			m_pIConnectionPoint;

	//Listeners
	CRowsetNotify*				m_pCRowsetNotify;
	CAsynchNotify*				m_pCAsynchNotify;

	//Data
	ULONG			m_ulEstimatedRows;
	ROWSETSOURCE	m_eRowsetSource;

	//Backpointers
	CDataSource*	m_pCDataSource;
	CSession*		m_pCSession;
	CCommand*		m_pCCommand;
	CRowPos*		m_pCRowPos;
	CMultipleResults* m_pCMultipleResults;
 	CDataset*		m_pCDataset;
 	
	//ColInfo
	ULONG			m_cColumns;
	DBCOLUMNINFO*	m_rgColumnInfo;
	WCHAR*			m_pStringBuffer;

	//Accessor
	ULONG			m_cBindings;
	DBBINDING*		m_rgBindings;
	HACCESSOR		m_hAccessor;
	void*			m_pData;
	
	//Bookmark Accessor
	ULONG			m_cBmkBindings;
	DBBINDING*		m_rgBmkBindings;
	HACCESSOR		m_hBmkAccessor;
	BOOL			m_fContainsBmk;
};


/////////////////////////////////////////////////////////////////
// CDataset 
//
/////////////////////////////////////////////////////////////////
class CDataset : public CBase
{
public:
	//Constructors
	CDataset(CMDIChild* pCMDIChild);
	~CDataset();
	
	//IUnknown Helpers
	virtual HRESULT SetInterface(REFIID riid, IUnknown* pIUnknown);
	virtual HRESULT ReleaseDataset();

	// Members
	virtual HRESULT	GetAxisInfo(ULONG* pcAxis, MDAXISINFO** pprgAxisInfo);
	virtual HRESULT	GetAxisRowset(REFIID riid, IUnknown** ppIRowset);
	virtual HRESULT	GetIMDDataset(REFIID riid, IUnknown** ppIUnknown);
	virtual HRESULT	GetNextCells(LONG cRows, ULONG* pcRowsObtained, HROW* prghRows);
	virtual HRESULT	GetCellData(HROW hRow, HACCESSOR hAccessor, void* pData);

	virtual HRESULT RestartPosition()			{ m_lCurCell = 0; return S_OK; }
	virtual ULONG	AxisCount(void)				{ return m_cAxis; }
	virtual BOOL	IsEndAxisRowset(void)		{ return m_cAxis <= m_lCurAxis+1; }
	virtual ULONG	ResetAxisRowset(void)		{ m_lCurAxis = 0; return m_cAxis; }
	virtual BOOL	SetAxisRowset(ULONG lAxis)	{ if (lAxis <= m_cAxis) m_lCurAxis = lAxis; return (lAxis <= m_cAxis? TRUE : FALSE); }

	//[MANADATORY]
	IAccessor*			m_pIAccessor;
	IColumnsInfo*		m_pIColumnsInfo;
	IConvertType*		m_pIConvertType;
	IMDDataset*			m_pIMDDataset;

	//[OPTIONAL]
	IMDFind*			m_pIMDFind;
	IMDRangeRowset*		m_pIMDRangeRowset;
	ISupportErrorInfo*	m_pISupportErrorInfo;

	// Data
	ULONG			m_cAxis, m_lCurAxis, m_lMaxCoord, m_lCurCell;
	MDAXISINFO*		m_rgAxisInfo;
	ULONG			m_rgAxisOffset[12];	// MAX_DIMS array of offset multipliers
};


/////////////////////////////////////////////////////////////////
// CMultipleResults 
//
/////////////////////////////////////////////////////////////////
class CMultipleResults : public CBase
{
public:
	//Constructors
	CMultipleResults(CMDIChild* pCMDIChild);
	virtual ~CMultipleResults();
	
	//IUnknown Helpers
	virtual HRESULT SetInterface(REFIID riid, IUnknown* pIUnknown);

	//Members
	virtual HRESULT CreateObject(IUnknown* pIUnknown);
	virtual HRESULT ReleaseObject();
	
	virtual HRESULT GetResult(REFIID riid, LONG* pcRowsAffected, IUnknown** ppIUnknown);
	
	//MultipleResults
	//[MANADATORY]
	IMultipleResults*			m_pIMultipleResults;

	//[OPTIONAL]
	ISupportErrorInfo*			m_pISupportErrorInfo;

	//Data
};


/////////////////////////////////////////////////////////////////
// CRowPos class
//
/////////////////////////////////////////////////////////////////
class CRowPos : public CBase
{
public:
	//Constructors
	CRowPos(CMDIChild* pCMDIChild);
	virtual ~CRowPos();

	//IUnknown Helpers
	virtual HRESULT SetInterface(REFIID riid, IUnknown* pIUnknown);

	//Methods
	virtual HRESULT CreateRowPos(IUnknown* pIRowset);
	virtual HRESULT ReleaseRowPos();

	//Helpers
	virtual HRESULT AdviseListeners();
	virtual HRESULT UnadviseListeners();

	//OLEDB Interfaces
	//[MANDATORY]
	IRowPosition*				m_pIRowPosition;

	//[OPTIONAL]
	IConnectionPointContainer*	m_pIConnectionPointContainer;	//DataSource interface

	//Extra interfaces
	IConnectionPoint*			m_pIConnectionPoint;

	//Listeners
	CRowPosChange*				m_pCRowPosChange;
};



#endif //_CTABLE_H_